#include "KPCIDIO.h"
static unsigned char PortA;
static CAObjHandle myPIO;
#include <cvirte.h>		
#include <userint.h>
#include "testDirectIO.h"

static int panelHandle;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "testDirectIO.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK cmdOPEN (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    // instanciate the object
			KPCIDIOLib_NewIKPCIPIO (NULL, 1, LOCALE_NEUTRAL, 0, &myPIO);
			// open the driver for device 0 of this object
			KPCIDIOLib_IKPCIPIOOpenDevice (myPIO, NULL, 0);
			break;
		}
	return 0;
}

int CVICALLBACK cmdEXIT (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			KPCIDIOLib_IKPCIPIOCloseDevice (myPIO, NULL);
			QuitUserInterface (0);
			break;
		}
	return 0;
}

int CVICALLBACK cmdREAD (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    // Port A is at an offset of 0
			KPCIDIOLib_IKPCIPIORead (myPIO, NULL, 0, &PortA);
			SetCtrlVal(panel,PANEL_NUMERIC,PortA);
			break;
		}
	return 0;
}

/*

Port A is at an offset of 0
Port B is at an offset of 1
Port C is at an offset of 2

The control register is at an offset of 3.

Individual bits of this register control the input or output direction
of the individual ports.  Write a 0 to the bit to make the corresponding
Port an output;  write a 1 to make it an input.  All ports are inputs by
default at PC power-up or reset.  If using only digital inputs, then the
control register is not important for your application.

bit 0.......4 lower bits of Port C
bit 1.......Port B
bit 2.......not used, always zero
bit 3.......4 upper bits of Port C
bit 4.......Port A
bit 5.......not used, always zero
bit 6.......not used, always zero
bit 7.......not used, always 1

To make all ports outputs, write a hex value of 80 to the control register
and then write to the registers for the individual ports to control their
logic 0 or 1 state.

Consult chapter 7 of the DriverLINX Tutorial Manual or the Using DriverLINX
with your KPCI-PIO Series manual for more information.
 
*/
